# 附件和主题购买通知功能 - Plugin版本

## 功能概述
为 `G:\veitoolthink-master\plugin\tt_credits` 插件添加了完整的购买通知功能，包括：
1. 购买付费附件后通知卖家
2. 购买付费主题后通知卖家
3. 独立的后台开关控制

## 新增功能

### 1. 附件购买通知
- **触发时机**: 用户下载付费附件时（扣除积分/金币/人民币）
- **通知对象**: 帖子作者（非下载者本人）
- **消息格式**: `{用户名}购买了您主题【{主题标题}】中的付费附件【{附件名}】！`

### 2. 主题购买通知
- **触发时机**: 用户购买付费主题内容时
- **通知对象**: 帖子作者（非购买者本人）
- **消息格式**: `{用户名}购买了您的主题【{主题标题}】！`

### 3. 后台管理控制
- **主题购买通知开关**: "购买付费主题后消息通知卖家"
- **附件购买通知开关**: "购买付费附件后消息通知卖家"
- **位置**: 插件后台设置页面

## 修改的文件列表

### 1. 核心功能文件
#### `hook/attach_output_before.php`
- **新增**: 第26-36行的附件购买通知逻辑
- **功能**: 在用户下载付费附件后发送通知

#### `hook/thread_start.php`
- **新增**: 第71-81行的主题购买通知逻辑
- **功能**: 在用户购买付费主题后发送通知

### 2. 后台管理文件
#### `admin_setcredits.php`
- **修改**: 第33-35行添加两个购买通知开关
- **功能**: 提供后台管理界面

### 3. 设置处理文件
#### `setting.php`
- **修改**: 第178-179行添加设置保存逻辑
- **功能**: 处理管理员的开关设置

### 4. 安装升级文件
#### `install.php`
- **修改**: 第44行在默认配置中添加通知设置
- **默认值**: 两个通知功能都默认关闭

#### `upgrade.php`
- **修改**: 第12-13行为现有用户添加新配置
- **默认值**: 通知功能默认关闭

## 配置项说明

### 新增配置键
1. **`buy_push`**: 主题购买通知开关
   - 值: `'0'`(关闭) / `'1'`(开启)
   - 默认: `'0'`

2. **`attach_buy_push`**: 附件购买通知开关
   - 值: `'0'`(关闭) / `'1'`(开启)
   - 默认: `'0'`

## 安全特性

### 1. 输入验证和转义
- 所有用户输入使用 `htmlspecialchars()` 转义
- 严格的参数验证和类型检查
- 防止XSS攻击

### 2. 逻辑安全
- 检查 `function_exists('notice_send')` 确保通知函数可用
- 避免用户给自己发送通知 (`$thread['uid'] != $uid`)
- 只在真正产生费用时发送通知

### 3. 数据完整性
- 验证用户和主题的有效性
- 防止重复通知发送
- 严格的数据库操作

## 使用指南

### 管理员设置
1. 进入插件后台管理页面
2. 找到积分规则设置区域
3. 勾选需要的通知选项：
   - ☑️ 购买付费主题后消息通知卖家
   - ☑️ 购买付费附件后消息通知卖家
4. 点击"确认"保存设置

### 前台使用
1. **设置付费内容**: 
   - 发帖时设置主题为付费
   - 上传附件时设置下载扣除积分
2. **用户购买**: 其他用户购买/下载付费内容
3. **通知接收**: 作者自动收到私信通知

## 兼容性说明

### 系统要求
- 需要安装通知系统插件（提供 `notice_send` 函数）
- 支持私信功能的论坛系统
- PHP 5.6+ 环境

### 插件兼容
- 与现有积分系统完全兼容
- 不影响原有的付费内容功能
- 可与其他通知插件协同工作

## 技术实现

### 通知机制
- 使用系统的 `notice_send()` 函数
- 消息类型: `1001` (系统通知)
- 异步发送，不影响用户操作

### 触发条件
- **附件通知**: `$credits < 0 || $golds < 0 || $rmbs < 0`
- **主题通知**: 成功执行付费购买操作
- **开关检查**: 对应的配置项为 `'1'`

### 错误处理
- 静默处理通知发送失败
- 不影响正常的购买流程
- 完善的日志记录机制

## 版本信息
- **实现日期**: 2024年当前
- **版本**: 基于 tt_credits 插件扩展
- **兼容性**: 支持 Xiuno BBS 4.0+ 系统

---

## 快速测试检查清单

### ✅ 安装检查
- [ ] 插件后台能看到两个新的通知开关
- [ ] 默认状态为关闭
- [ ] 设置能正常保存

### ✅ 功能测试
- [ ] 开启附件通知，下载付费附件能收到通知
- [ ] 开启主题通知，购买付费主题能收到通知
- [ ] 作者自己操作不会收到通知
- [ ] 免费内容不会触发通知

### ✅ 安全测试  
- [ ] 消息内容正确转义，无XSS风险
- [ ] 参数验证有效，无注入风险
- [ ] 异常情况下不影响正常功能
